/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbcserver;

import com.mckoi.database.jdbc.DatabaseInterface;
import com.mckoi.database.jdbcserver.JDBCProcessor;
import com.mckoi.database.jdbcserver.ServerConnection;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.LengthMarkedBufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class StreamJDBCServerConnection
extends JDBCProcessor
implements ServerConnection {
    private static final int OUTPUT_BUFFER_SIZE = 32768;
    private static final int INPUT_BUFFER_SIZE = 16384;
    private LengthMarkedBufferedInputStream marked_input;
    private DataOutputStream out;

    StreamJDBCServerConnection(DatabaseInterface db_interface, InputStream in, OutputStream out, DebugLogger logger) throws IOException {
        super(db_interface, logger);
        this.marked_input = new LengthMarkedBufferedInputStream(in);
        this.out = new DataOutputStream(new BufferedOutputStream(out, 32768));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(byte[] event_msg) throws IOException {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.writeInt(8 + event_msg.length);
            this.out.writeInt(-1);
            this.out.writeInt(75);
            this.out.write(event_msg, 0, event_msg.length);
            this.out.flush();
        }
    }

    public boolean requestPending() throws IOException {
        int state = this.getState();
        if (state == 100) {
            return this.marked_input.pollForCommand(Integer.MAX_VALUE);
        }
        return this.marked_input.pollForCommand(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest() throws IOException {
        int sequence_limit = 8;
        int com_length = this.marked_input.available();
        while (com_length > 0) {
            byte[] command = new byte[com_length];
            for (int read_index = 0; read_index < com_length; read_index += this.marked_input.read(command, read_index, com_length - read_index)) {
            }
            byte[] response = this.processJDBCCommand(command);
            if (response != null) {
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(response.length);
                    this.out.write(response);
                    this.out.flush();
                }
            }
            com_length = 0;
            if (sequence_limit <= 0 || !this.requestPending()) continue;
            com_length = this.marked_input.available();
            --sequence_limit;
        }
    }

    public void blockForRequest() throws IOException {
        this.marked_input.blockForCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() throws IOException {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.writeInt(8);
            this.out.writeInt(-1);
            this.out.writeInt(65);
            this.out.flush();
        }
    }
}

